unit zipmidas;

(*

zipping packets
        override
            for getting data
                doGetRecords in tClientDataset and
                internalGetRecords in tBaseProvider

            for sending data
                doApplyUpdates in tclientdataset
                internalApplyUpdates in tbaseprovider

        publish
            for getting data (in provider)
                //zipPackets : boolean; to indicate whether to bother zipping
                zipThreshhold : integer; minimum size of packet to zip

            for sending data (in dataset)
                //zipPackets : boolean; to indicate whether to bother zipping
                zipThreshhold : integer; minimum size of packet to zip


*)


(* requires DelphiZLib from http://www.base2ti.com *)

(*
  each zipped packet contains ziptag followed by the size of uncompressed data (an unsigned integer)

*)

interface

uses
  Windows, Messages, SysUtils, DBClient, classes, provider, zlibex, activex;

type
    tlogproc = procedure(s : string) of object;

type
  TZipClientDataSet = class(TClientDataSet)
  private
    { Private declarations }
    fZipThreshhold : integer;
  protected
    { Protected declarations }
    function DoGetRecords(Count: Integer; out RecsOut: Integer; Options: Integer;
       const CommandText: WideString; Params: OleVariant): OleVariant; override;
    function DoApplyUpdates(Delta: OleVariant; MaxErrors: Integer; out ErrorCount: Integer): OleVariant; override;

  public
    { Public declarations }
    constructor create(aOwner : tComponent); override;

  published
    { Published declarations }
    // if minimumzipsize < 0 then no compression, otherwise specifies the minimum size of packet to compress
    property MinimumZipSize : integer read fZipThreshhold write fZipThreshhold default -1;
  end;

  (*
  tHackDataPacketWriter = class(tDataPacketWriter)
  published
    property onGetParams;
  end;
  *)
  TZipDataSetProvider = class(TDataSetProvider)
  private
    { Private declarations }
    fZipThreshhold : integer;
    //FDSWriter : THackDataPacketWriter;
  protected
    { Protected declarations }
    function InternalGetRecords(Count: Integer; out RecsOut: Integer;
      Options: TGetRecordOptions; const CommandText: WideString;
      var Params: OleVariant): OleVariant; override;
    function InternalApplyUpdates(const Delta: OleVariant; MaxErrors: Integer;
      out ErrorCount: Integer): OleVariant; override;

    (*
    procedure CreateDataPacket(PacketOpts: TGetRecordOptions;
  ProvOpts: TProviderOptions; var RecsOut: Integer; var Data: OleVariant); override;
    *)
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    
  published
    { Published declarations }
    property MinimumZipSize : integer read fZipThreshhold write fZipThreshhold default -1;
  end;

procedure Register;

var
   logproc : tlogproc;

implementation

const
     ziptag = 'ZIPMIDAS1.0';


procedure Register;
begin
  RegisterComponents('Midas', [TZipClientDataSet, TZipDataSetProvider]);
end;


(*
type
 tBufferStream = class (tMemoryStream)
 public
   // making this procedure public
   procedure SetPointer(Ptr: Pointer; Size: Longint);
 end;


procedure TBufferStream.SetPointer(Ptr: Pointer; Size: Longint);
begin
      inherited setPointer(Ptr, Size);
end;
*)

function zipPacket(input : Variant; minsize : integer) : oleVariant;
(* compresses contents of input if size of input is > 0 and < minsize *)
var

   datasize: integer;
   i : integer;

   p : pointer;
   dataptr : pointer;
   outptr : pointer;
   outsize : integer;

   t1, t2 : tDateTime;
begin

   dataSize := 1;
   for i := 1 to VarArrayDimCount(input) do
       datasize := datasize * (varArrayHighBound(input, 1) - varArrayLowBound(input, i) + 1);


   if assigned(logproc) then
      logproc('Entering zipPacket(). Data Size : ' + intToStr(dataSize));
   t1 := now;
   outsize := datasize;
   try

      if (not varIsArray(input)) or (minsize < 0) or (datasize < minsize) or (datasize = 0) then begin
          result := input;
          exit;
      end;


      try
         dataptr := VarArrayLock(input);
         ZCompress(dataptr, datasize, outptr, outsize, zcMax);
      finally
         VarArrayUnlock(input);
      end;


      result := varArrayCreate([0, outsize + length(ziptag) + sizeof(datasize) - 1], varByte);
      p := varArrayLock(result);
      try
        //s := ziptag
        CopyMemory(p, pchar(ziptag), length(ziptag));
        copymemory(pointer(longint(p) + length(ziptag)), addr(datasize), sizeof(datasize));
        copyMemory(pointer(longint(p) + length(ziptag) + sizeof(ziptag)), outptr, outsize);
      finally
        varArrayUnlock(result);
      end;

   finally
      t2 := now;
      if Assigned(logproc) then
         logProc('Exiting zipPacket(). Result Size : ' + intToStr(outsize) + ', time used : ' + formatDateTime('nn:ss:zzzz', t2 - t1));
   end;

end;

function unzipPacket(input : OleVariant) : oleVariant;
var
  dataptr, outptr, p : pointer;
  //bs2 : tBufferStream;
  //buff : array[0..8191] of byte;

  s : string;
  i, datasize : integer;
  finalsize : integer;
  outsize : integer;

  t1, t2 : tdatetime;

begin
  result := input;
  if not varIsArray(input) then exit;

  datasize := 1;
  for i := 1 to VarArrayDimCount(input) do
      datasize := datasize * (varArrayHighBound(input, i) - varArrayLowBound(input, i) + 1);

  if assigned(logproc) then
      logproc('Entering unzipPacket(). Data Size : ' + intToStr(dataSize));
  t1 := now;
  outsize := datasize;

  try

    if datasize < (length(ziptag) + sizeof(integer)) then exit;


    try

       dataptr := varArrayLock(input);

       setLength(s, length(ziptag) + 1);
       CopyMemory(addr(s[1]), dataptr, length(ziptag));
       if pos(ziptag, s) <= 0 then begin
          exit;
       end;

       CopyMemory(addr(finalsize), ptr(longint(dataptr) + length(ziptag)), sizeof(finalsize));

       ZDecompress(ptr(longint(dataptr) + length(ziptag) + sizeof(finalsize)), datasize - (length(ziptag) + sizeof(integer)), outptr, outsize, finalsize);

    finally
      varArrayUnlock(input);
    end;

    result := VarArrayCreate([0, outsize - 1], varByte);
    p := varArrayLock(result);
    try
       copymemory(p, outptr, outsize);
    finally
       varArrayUnlock(result);
    end;

  finally
      t2 := now;
      if Assigned(logproc) then
         logProc('Exiting unzipPacket(). Result Size : ' + intToStr(outsize) + ', time used : ' + formatDateTime('nn:ss:zzzz', t2 - t1));

  end;
end;

(* tZipClientDataset *)

function TZipClientDataset.DoGetRecords(Count: Integer; out RecsOut: Integer; Options: Integer;
       const CommandText: WideString; Params: OleVariant): OleVariant;
begin
  result := unzipPacket(inherited DoGetRecords(count, recsOut, Options, CommandText, Params));
end;

function TZipClientDataset.DoApplyUpdates(Delta: OleVariant; MaxErrors: Integer; out ErrorCount: Integer): OleVariant;
begin
  delta := zipPacket(delta, fZipThreshhold);
  result := inherited DoApplyUpdates(delta, maxErrors, errorCount)
end;

constructor TZipClientDataset.Create(AOwner: TComponent);
begin
     inherited create(aOwner);
     fZipThreshhold := -1;
end;


(* tZipDataSetProvider *)


function TZipDataSetProvider.InternalGetRecords(Count: Integer; out RecsOut: Integer;
      Options: TGetRecordOptions; const CommandText: WideString;
      var Params: OleVariant): OleVariant;
begin
  result := zipPacket(inherited InternalGetRecords(Count, RecsOut, Options, CommandText, Params), fZipThreshhold);
end;

function TZipDataSetProvider.InternalApplyUpdates(const Delta: OleVariant; MaxErrors: Integer;
      out ErrorCount: Integer): OleVariant;
begin
  result := inherited InternalApplyUpdates(unzipPacket(delta), maxErrors, ErrorCount);

end;


constructor TZipDataSetProvider.Create(AOwner: TComponent);
begin
     inherited create(aOwner);
     fZipThreshhold := -1;
end;


(*
procedure TZipDataSetProvider.CreateDataPacket(PacketOpts: TGetRecordOptions;
  ProvOpts: TProviderOptions; var RecsOut: Integer; var Data: OleVariant);
begin
  //inherited;

  if not Assigned(FDSWriter) then
    FDSWriter := THackDataPacketWriter.Create;
  FDSWriter.Constraints := Constraints;
  FDSWriter.OnGetParams := DoGetProviderAttributes;
  FDSWriter.PacketOptions := PacketOpts;
  FDSWriter.Options := ProvOpts;
  FDSWriter.GetDataPacket(DataSet, RecsOut, Data);
  FreeAndNil(fdswriter);

end;
*)

end.
