unit propsheet;

interface

uses
  Windows, messages, ActiveX, Classes, ComObj, ShlObj, CommCtrl, comserv, shellapi, sysutils;

type
  TMp3PropertySheet = class(TComObject, IShellExtInit, IShellPropSheetExt)
  private
    fFileName : string;
    function IShellExtInit.Initialize = initShellExtension;
  protected
    {Declare IShellExtInit methods here}
    function InitShellExtension(pidlFolder : pItemIDList; lpdObject : IDataObject; hkeyProgID : HKEY) : HRESULT; stdcall;

    {Declare IShellPropSheetExt methods here}
    function AddPages(lpfnAddPage : TFnAddPropSheetPage; lParam : LPARAM) : HRESULT; stdcall;
    function ReplacePage(uPageID : UINT; lpfnReplaceWith : TFNAddPropSheetPage; lParam : LPARAM) : HRESULT; stdcall;

  end;

  tMp3PropertySheetFactory = class(TComObjectFactory)
  public
    procedure UpdateRegistry(Register : boolean); override;
  end;
const
  Class_Mp3PropertySheet: TGUID = '{B8E97F0A-9A95-42D2-B39D-E8A762E88181}';

implementation
uses registry, id3v2, audioinfo;

const
     idd_mp3id3 = 1000;
     idc_artist = 101;
     idc_album  = 102;
     idc_track  = 103;
     IDC_COMMENT = 104;
     IDC_BITRATE = 105;
     IDC_LENGTH  = 106;
     IDC_SAMPLE  = 107;


{$R DLG.RES}


function propSheetDlgProc(hDlg : HWND; uMessage : UINT; wParam : WPARAM; lParam : LPARAM) : boolean; stdcall;
var
   psp : pPropSheetPage;
   ps  : TMp3PropertySheet;
   i : integer;

   audInfo : TAudioInfo;
   tagv2 : TID3v2;


   sTitle, sArtist, sAlbum : string;
   sComment : string;

   sBitRate : string;
   sLength  : string;
   sSample  : string;
begin


  case uMessage of
       WM_INITDIALOG : begin

                            psp := ppropSheetPage(lParam);
                            ps  := TMp3PropertySheet(psp.lParam);

                            audInfo := TAudioInfo.Create;
                            tagv2 := TID3v2.create;

                            sTitle := '';
                            sArtist := '';
                            sAlbum := '';
                            sComment := '';


                            try
                               audInfo.LoadFromFile(ps.fFileName);
                               if audInfo.ID3.Ok then begin
                                  sTitle := audInfo.ID3.Title;
                                  sArtist := audInfo.ID3.Artist;
                                  sAlbum := audInfo.ID3.Album;
                                  sComment := audInfo.ID3.Comment;
                               end;

                               tagv2.ReadFromFile(ps.fFileName);
                               if tagv2.Exists then
                                  if trim(tagv2.Comment + tagv2.Artist + tagv2.title + tagv2.Album) <> '' then begin
                                    sTitle   := tagv2.Title;
                                    sArtist  := tagv2.Artist;
                                    sAlbum   := tagv2.Album;
                                    sComment := tagv2.Comment;
                                  end;
                                  
                               if audInfo.Mpg.ok then begin
                                  if audInfo.Mpg.SamplingRate > 0 then
                                     sSample := formatFloat('#,', audInfo.Mpg.SamplingRate)
                                  else
                                     sSample := '';

                                  if audInfo.Mpg.KBitRate > 0 then begin
                                     sBitRate := format('%d Kbps', [audInfo.Mpg.KBitRate]);
                                     if audInfo.xingVbr then
                                        sBitRate := sBitRate + ' VBR'; 
                                  end
                                  else
                                     sBitRate := '';

                                  if audInfo.MpegDuration > 0 then begin
                                     i := audInfo.MpegDuration div 1000;

                                     if i > 3600 then
                                        sLength := format('%d:%.2d:%.2d', [i div 3600, (i mod 3600) div 60, (i mod 60)])
                                     else
                                       sLength := format('%d:%.2d', [i div 60, i mod 60]);
                                  end
                                  else sLength := '';
                               end;

                               SetDlgItemText(hDlg, IDC_ARTIST,  pChar(sArtist));
                               SetDlgItemText(hDlg, IDC_ALBUM,   pChar(sAlbum));
                               SetDlgItemText(hDlg, IDC_TRACK,   pChar(sTitle));
                               SetDlgItemText(hDlg, IDC_COMMENT, pChar(sComment));
                               SetDlgItemText(hDlg, IDC_BITRATE, pChar(sBitRate));
                               SetDlgItemText(hDlg, IDC_LENGTH,  pChar(sLength));



                            finally
                              audInfo.free;
                              tagv2.free;
                            end;

                            (*
                            try
                              try
                                 if tagv2.ReadFromFile(ps.fFileName) then begin
                                    if tagv2.Exists then begin
                                       SetDlgItemText(hDlg, IDC_ARTIST, pChar(tagv2.Artist));

                                       SetDlgItemText(hDlg, IDC_ALBUM,  pChar(tagv2.Album));

                                       SetDlgItemText(hDlg, IDC_TRACK,  pChar(tagv2.Title));
                                     end;
                                 end
                                 else if tagv1.ReadFromFile(ps.fFileName) then begin
                                   if tagv1.exists then begin
                                     showmessage('tagv1 exists');

                                     tempstr := tagv1.Artist;
                                     SetDlgItemText(hDlg, IDC_ARTIST, pChar(tempstr));

                                     tempstr := tagv1.Album;
                                     SetDlgItemText(hDlg, IDC_ALBUM,  pChar(tempstr));

                                     tempstr := tagv1.Title;
                                     SetDlgItemText(hDlg, IDC_TRACK,  pChar(tempstr));

                                   end;
                                 end;
                              except
                                on e:exception do showException(e, erroraddr);
                              end;
                            finally
                              tagv1.free;
                              tagv2.free;
                            end;
                            *)
                            updateWindow(hDlg);
                            result := true;
                       end;
       else
           Result := false;
  end;

end;

function propSheetDlgCallback(hWnd : hwnd; uMessage : UINT; var psp : TPropSheetPage) : UINT; stdcall;
begin


    if uMessage = PSPCB_RELEASE then begin
       //if psp.lParam <> 0 then begin
       //   TMp3PropertySheet(psp.lParam)._Release;
       //end;
    end
    else begin



    end;
    Result := 1;
end;


function TMp3PropertySheet.InitShellExtension(pidlFolder : pItemIDList; lpdObject : IDataObject; hkeyProgID : HKEY) : HRESULT;
(* I do not understand anything here *)
var
   medium : tStgMedium;
   Format : TFormatEtc;
   filename : pchar;
   buffsize : integer;
begin



  if lpdObject = nil then begin
     result := E_FAIL;
     exit;
  end;

  with format do begin
       cfFormat := CF_HDROP;
       ptd      := nil;
       dwAspect := DVASPECT_CONTENT;
       lindex   := -1;
       tymed    := TYMED_HGLOBAL;
  end;

  Result := lpdObject.GetData(format, medium);
  if failed(result) then exit;

  try
     if DragQueryFile(Medium.hGlobal, $FFFFFFFF, nil, 0) = 1 then begin
        buffsize := DragQueryFile(medium.hGlobal, 0, nil, 0);
        filename := StrAlloc(buffsize + 2);
        DragQueryFile(medium.hGlobal, 0, fileName, buffsize + 1);
        fFileName := strpas(fileName);
        StrDispose(filename);
        result := NOERROR;
     end
     else result := E_FAIL;
  finally
     ReleaseStgMedium(medium);
  end;
end;

function tMp3PropertySheet.AddPages(lpfnAddPage : TFnAddPropSheetPage; lParam : LPARAM) : HRESULT;
var
   psp : TPropSheetPage;
   hPage : HPropSheetPage;
begin


   fillChar(psp, sizeof(psp), 0);
   psp.dwSize    := sizeof(psp);
   psp.dwFlags   := PSP_USETITLE or PSP_USECALLBACK;
   psp.hInstance := hinstance;
   psp.pszTemplate := MakeintResource(IDD_mp3id3);
   psp.pszTitle    := 'Mp3';
   psp.pfnDlgProc  := @propsheetDlgProc;
   psp.pfnCallback := @propSheetDlgCallback;
   psp.lParam := integer(self);


   Result := E_FAIL;

   hPage := CreatePropertySheetPage(psp);
   if hPage <> nil then begin
      if not lpfnAddPage(hPage, lParam) then begin
         DestroyPropertySheetPage(hPage);
      end
      else begin
           _AddRef;
           result := NOERROR;
      end;
   end;

end;

function TMp3PropertySheet.ReplacePage(uPageID : UINT; lpfnReplaceWith : TFNAddPropSheetPage; lParam : LPARAM) : HRESULT;
begin
    Result := E_NOTIMPL;
end;

procedure TMp3PropertySheetFactory.UpdateRegistry(Register : boolean);
var
  reg : tRegistry;

  s : string;    
begin
  inherited;

  reg := TRegistry.Create;
  try
     reg.RootKey := HKEY_CLASSES_ROOT;
     if Register then begin
        reg.OpenKey('.mp3', true);
        s := reg.ReadString('');
        if s = '' then begin
           s := 'Mp3File';
           reg.WriteString('', s);
        end;
        CreateRegKey(s + '\shellex\PropertySheetHandlers\' + ClassName, '', GUIDToString(ClassID));
     end
     else begin
        if not reg.OpenKey('.mp3', false) then exit;
        s := reg.ReadString('');
        if s = '' then exit;
        DeleteRegKey(s + '\shellex\PropertySheetHandlers\' + ClassName);

     end;

  finally
    reg.closeKey;
    reg.free;
  end;
end;




initialization
  TMp3PropertySheetFactory.Create(ComServer, TMp3PropertySheet, Class_Mp3PropertySheet,
    'Mp3PropertySheet', '', ciMultiInstance, tmApartment);
end.
